 ; Ŀ
 ;   Drawlist - insert a cdf file into a drawing list.                     
 ;   Copyright 1995, 1997, 2001 by Rocket Software                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Drawlist.                                                             
 ; 
 (DEFUN C:DRAWLIST (/ ss fn num pa linn llist dwgno revno dwgttl caddno
                                                            lup namm gnunam)
  (setvar "cmdecho" 0)
  (setvar "attreq" 1)
  (setvar "limcheck" 0)
 ; Ŀ
 ;   Erase all existing data block insertions.                             
 ; 
  (if (setq ss (ssget "X" (list (cons 2 "listtext"))))
      (command ".erase" ss ""))
 ; Ŀ
 ;   Get the cdf file name.                                                
 ; 
  (setq filnam (getfiled "Data File" "Titledat.cdf" "" 0))
  (if (= filnam 1)
      (progn
           (setq filnam (Getstring "Data file name <Titledat.cdf>: "))
           (if (= filnam "") (setq filnam "Titledat.cdf"))))
 ; Ŀ
 ;   Open the file, initialise variables.                                  
 ; 
  (if (setq fn (open filnam "r"))
      (progn
           (setq num 0)
           (setq subnum 0)
           (setq pa (list 25 515))
 ; Ŀ
 ;   Read each line from the file, convert to uppercase, divide into a     
 ;   list of strings.                                                      
 ; 
           (while (setq linn (read-line fn))
                  (setq linn (strcase linn))
                  (setq llist0 (csplit linn))
 ; Ŀ
 ;   Reorder the list.                                                     
 ; 
                  (setq llist (list (nth 0 llist0)
                                    (nth 1 llist0)
                                    (nth 2 llist0)
                                    (nth 3 llist0)))
 ; Ŀ
 ;   Insert a data block, read the values from the string list Llist into  
 ;   the attributes, fill extras with empty strings.                       
 ; 
                  (command ".insert" "listtext" pa "" "" "")
                  (while (and (setq nexstr (car llist))
                              (= 1 (getvar "cmdactive")))
                         (setq llist (cdr llist))
                         (command nexstr))
                  (while (= 1 (getvar "cmdactive"))
                         (command ""))
 ; Ŀ
 ;   Deal with positioning and multiple sheets.                            
 ; 
                  (setq num (1+ num))
                  (if (= num 90)
                      (progn
                           (setq pa (list 25 515))
                           (setq num 0)
                           (setq lup (getvar "luprec"))
                           (setvar "luprec" 8)
                           (setq namm (rtos (getvar "date"))) ; get exact time
                           (setq namm (strcat "TT" (substr namm 11)))
                           (setvar "luprec" lup)
                           (setq gnunam (getstring (strcat "Second page name <"
                                                            namm ">: ")))
                           (if (= gnunam "") (setq gnunam namm))
                           (command ".qsave")
                           (command ".saveas" gnunam)
                           (setq ss (ssget "X" (list (cons 2 "listtext"))))
                           (command ".erase" ss ""))
                      (setq pa (polar pa (* pi 1.5) 7.5))))
           (close fn)))
 (princ))